
import SwiftUI

nonisolated struct ApplicationData {
   @concurrent
   func loadImage(name: String) async -> String {
      async let t1 = taskNumber1()
      async let t2 = taskNumber2()
      return "Values returned: \(await t1) / \(await t2)"
   }
   func taskNumber1() -> String {
      sleep(5)
      return "Task 1"
   }
   func taskNumber2() -> String {
      sleep(5)
      return "Task 2"
   }
}
struct ContentView: View {
   let appData = ApplicationData()

   var body: some View {
      VStack {
         Text("Hello, world!")
            .padding()
         Button("Run Task") {
            Task {
               let imageName = await appData.loadImage(name: "My Image")
               print(imageName)
            }
         }
      }
   }
}

#Preview {
    ContentView()
}
